/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth;

import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.ui.UIObjectProperties;
import com.ibm.hwmca.fw.ui.UIObjectsReader;
import com.ibm.hwmca.fw.ui.UIObjectsWriter;
import com.ibm.hwmca.fw.ui.UIPropertyChangeSupport;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.BonsaiUIStyle;
import com.ibm.hwmca.ui.bonsai.config.BonsaiConfigException;
import com.ibm.hwmca.ui.bonsai.config.TaskRetrieverConfigBean;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeManager;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.Targetable;
import com.ibm.hwmca.ui.bonsai.earth.TaskNode;
import com.ibm.hwmca.ui.bonsai.earth.util.TaskRetriever;
import com.ibm.hwmca.ui.bonsai.servlet.ControllerServlet;
import com.ibm.hwmca.ui.bonsai.servlet.util.TaskUrl;
import com.ibm.hwmca.ui.bonsai.servlet.util.UIRefreshManager;
import com.ibm.hwmca.ui.bonsai.servlet.util.UserObject;
import com.ibm.hwmca.ui.bonsai.util.SortedList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TaskManager
implements PropertyChangeListener {
    private static final String TRACEMASK_T = "XBUITKMT";
    private static final String TRACEMASK_F = "XBUITKMF";
    private static final String TRACEMASK_D = "XBUITKMD";
    private static final String NODE_CLUSTERS_SESSION_KEY = "task_sets";
    private static TaskManager taskManager;
    private static final Object LOCK;
    private List rootNodes;
    private Map retrievers;

    private TaskManager(List taskRetrieverConfigBeans) throws BonsaiConfigException {
        Trace.trace(TRACEMASK_F, "> TaskManager(" + taskRetrieverConfigBeans + ")");
        boolean initialized = false;
        while (!initialized) {
            try {
                this.retrievers = new HashMap(taskRetrieverConfigBeans.size());
                TaskRetrieverConfigBean configBean = null;
                TaskRetriever taskRetriever = null;
                Iterator i = taskRetrieverConfigBeans.iterator();
                while (i.hasNext()) {
                    configBean = (TaskRetrieverConfigBean)i.next();
                    try {
                        taskRetriever = (TaskRetriever)Class.forName(configBean.getClassName()).newInstance();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    taskRetriever.init(configBean.getKey(), configBean.getParameters());
                    this.retrievers.put(configBean.getKey(), taskRetriever);
                }
                this.buildFullTaskTrees();
                initialized = true;
            }
            catch (RuntimeException rtEx) {
                try {
                    Thread.sleep(4000L);
                }
                catch (InterruptedException iEx) {}
            }
        }
        Trace.trace(TRACEMASK_F, "< TaskManager()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(List taskRetrieverConfigBeans) throws BonsaiConfigException {
        Trace.trace(TRACEMASK_T, "<--> TaskManager.init(" + taskRetrieverConfigBeans + ")");
        Object object = LOCK;
        synchronized (object) {
            if (taskManager == null) {
                taskManager = new TaskManager(taskRetrieverConfigBeans);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskManager getTaskManager() {
        Object object = LOCK;
        synchronized (object) {
            return taskManager;
        }
    }

    public TaskRetriever getTaskRetriever(String key) {
        return (TaskRetriever)this.retrievers.get(key);
    }

    public List getFullTaskTree() {
        return this.rootNodes;
    }

    public String getDefaultTaskUrl(BonsaiTreeNode node) {
        if (!(node instanceof Targetable)) {
            return null;
        }
        return ((Targetable)((Object)node)).getDefaultTaskUrl();
    }

    public void clearCachedTasks(UserObject userObj) {
        userObj.setTableSelectionTaskTrees(null);
        userObj.getHMCSession().removeSessionAttribute(NODE_CLUSTERS_SESSION_KEY);
    }

    public void resetCachedTasks(UserObject userObj) {
        this.clearCachedTasks(userObj);
        this.updateCachedTasks(new ArrayList(0), BonsaiTreeManager.getBonsaiTreeManager().getTreeNodes(userObj.getTableSelection()), userObj);
    }

    public boolean updateCachedTasks(List formerSelectedNodes, List newSelectedNodes, UserObject userObj) {
        boolean updateRequired = false;
        HMCSession hmcSession = userObj.getHMCSession();
        ArrayList nodeClusters = (ArrayList)hmcSession.getSessionAttribute(NODE_CLUSTERS_SESSION_KEY);
        if (nodeClusters == null) {
            nodeClusters = new ArrayList();
            hmcSession.setSessionAttribute(NODE_CLUSTERS_SESSION_KEY, nodeClusters);
        }
        ArrayList deselectedNodes = new ArrayList(formerSelectedNodes);
        deselectedNodes.removeAll(newSelectedNodes);
        Set cluster = null;
        BonsaiTreeNode node = null;
        Iterator i = deselectedNodes.iterator();
        block0: while (i.hasNext()) {
            node = (BonsaiTreeNode)i.next();
            Iterator j = nodeClusters.iterator();
            while (j.hasNext()) {
                cluster = (Set)j.next();
                if (!cluster.remove(node)) continue;
                if (!cluster.isEmpty()) continue block0;
                j.remove();
                updateRequired = true;
                continue block0;
            }
        }
        ArrayList selectedNodes = new ArrayList(newSelectedNodes);
        selectedNodes.removeAll(formerSelectedNodes);
        Iterator i2 = selectedNodes.iterator();
        while (i2.hasNext()) {
            node = (BonsaiTreeNode)i2.next();
            boolean foundNodesCluster = false;
            Iterator j = nodeClusters.iterator();
            while (j.hasNext() && !foundNodesCluster) {
                cluster = (Set)j.next();
                if (!((BonsaiTreeNode)cluster.iterator().next()).guaranteesSameTaskSet(node)) continue;
                cluster.add(node);
                foundNodesCluster = true;
            }
            if (foundNodesCluster) continue;
            HashSet<BonsaiTreeNode> newCluster = new HashSet<BonsaiTreeNode>();
            newCluster.add(node);
            nodeClusters.add(newCluster);
            updateRequired = true;
        }
        if (!updateRequired) {
            return false;
        }
        ArrayList clusterRepresentativeNodes = new ArrayList(nodeClusters.size());
        Iterator i3 = nodeClusters.iterator();
        while (i3.hasNext()) {
            clusterRepresentativeNodes.add(((Set)i3.next()).iterator().next());
        }
        userObj.setTableSelectionTaskTrees(this.getTasks(clusterRepresentativeNodes, userObj));
        return true;
    }

    public List getTasks(List selectedNodes, UserObject userObj) {
        Iterator i = selectedNodes.iterator();
        if (!i.hasNext()) {
            return new ArrayList(0);
        }
        List tasks = this.getTasks((BonsaiTreeNode)i.next(), userObj);
        while (i.hasNext()) {
            tasks = this.intersectTaskTrees(tasks, this.getTasks((BonsaiTreeNode)i.next(), userObj));
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTasks(BonsaiTreeNode selectedNode, UserObject userObj) {
        Object object = LOCK;
        synchronized (object) {
            return selectedNode.getTasks(userObj);
        }
    }

    public List getTasksWithTargets(List selectedNodes, UserObject userObj) {
        List tasks = this.getTasks(selectedNodes, userObj);
        ArrayList<String> targetIds = new ArrayList<String>(selectedNodes.size());
        String parentId = null;
        Targetable target = null;
        Iterator i = selectedNodes.iterator();
        while (i.hasNext()) {
            target = (Targetable)i.next();
            targetIds.add(target.getShortId());
            if (parentId != null) continue;
            parentId = target.getParentShortId();
        }
        this.setTaskTargets(tasks, targetIds, parentId);
        return tasks;
    }

    public List getTasksWithTargets(BonsaiTreeNode selectedNode, UserObject userObj) {
        List tasks = this.getTasks(selectedNode, userObj);
        Targetable target = (Targetable)((Object)selectedNode);
        ArrayList<String> targetIds = new ArrayList<String>(1);
        targetIds.add(target.getShortId());
        this.setTaskTargets(tasks, targetIds, target.getParentShortId());
        return tasks;
    }

    public void propertyChange(PropertyChangeEvent event) {
        byte[] props;
        byte type;
        if (event.getPropertyName().equals("Root") && (type = UIObjectProperties.getType(props = ControllerServlet.getUIObjectsReader().getBuffer((String)event.getSource(), true))) != 52 && type != 54) {
            return;
        }
        UIPropertyChangeSupport registry = UIObjectsWriter.getUIObjectsWriter().getUIPropertyChangeSupport();
        registry.removeAllPropertyChangeListener(this);
        registry.removeRootPropertyChangeListener(this);
        this.buildFullTaskTrees();
        Iterator i = BonsaiUIStyle.getActiveBonsaiHMCSessions().iterator();
        while (i.hasNext()) {
            this.resetCachedTasks(UserObject.getUserObject((HMCSession)i.next()));
        }
        UIRefreshManager.refresh(0);
    }

    private void buildFullTaskTrees() {
        UIObjectsReader reader = ControllerServlet.getUIObjectsReader();
        UIPropertyChangeSupport registry = UIObjectsWriter.getUIObjectsWriter().getUIPropertyChangeSupport();
        Set rootTaskGroupShortIds = reader.getRootTaskGroupShortIds(false);
        this.rootNodes = this.buildTaskTrees(rootTaskGroupShortIds, reader, registry);
        registry.addRootPropertyChangeListener(this);
    }

    private List buildTaskTrees(Collection nodeShortIds, UIObjectsReader reader, UIPropertyChangeSupport registry) {
        SortedList nodes = new SortedList(TaskNode.getComparator());
        TaskNode node = null;
        String id = null;
        boolean isTask = false;
        UIInfo uiInfo = null;
        byte[] props = null;
        Iterator i = nodeShortIds.iterator();
        while (i.hasNext()) {
            id = (String)i.next();
            props = reader.getBuffer(id);
            uiInfo = new UIInfo(UIObjectProperties.getName(props), UIObjectProperties.getCaption(props), UIObjectProperties.getImageName(props));
            isTask = UIObjectProperties.isTask(props);
            TaskNode taskNode = node = isTask ? new TaskNode(id, uiInfo, new TaskUrl(id, 2), true, UIObjectProperties.isDisruptive(props)) : new TaskNode(id, uiInfo);
            if (!isTask) {
                node.addChildren(this.buildTaskTrees(reader.getChildrenShortIds(id), reader, registry));
                registry.addPropertyChangeListener("Children", id, this);
            }
            nodes.add(node);
        }
        return nodes;
    }

    private List intersectTaskTrees(List nodes1, List nodes2) {
        class QuickSearchTaskNodeList
        extends ArrayList {
            private Map nodeMap;

            public QuickSearchTaskNodeList(List taskNodes) {
                this.nodeMap = new HashMap(taskNodes.size());
                TaskNode node = null;
                Iterator i = taskNodes.iterator();
                while (i.hasNext()) {
                    node = (TaskNode)i.next();
                    this.nodeMap.put(node.getId(), node);
                    this.add(node);
                }
            }

            public TaskNode findNode(String id) {
                return (TaskNode)this.nodeMap.get(id);
            }
        }
        QuickSearchTaskNodeList qsList1 = new QuickSearchTaskNodeList(nodes1);
        QuickSearchTaskNodeList qsList2 = new QuickSearchTaskNodeList(nodes2);
        class DeepCloneTaskNodeList
        extends ArrayList {
            public DeepCloneTaskNodeList(List taskNodes) {
                TaskNode node = null;
                Iterator i = taskNodes.iterator();
                while (i.hasNext()) {
                    node = ((TaskNode)i.next()).getNoChildrenClone();
                    this.add(node);
                }
            }
        }
        DeepCloneTaskNodeList intersection = new DeepCloneTaskNodeList(qsList1);
        intersection.retainAll(qsList2);
        TaskNode node = null;
        Iterator i = intersection.iterator();
        while (i.hasNext()) {
            node = (TaskNode)i.next();
            if (node.isTask()) continue;
            List children = this.intersectTaskTrees(qsList1.findNode(node.getId()).getChildren(), qsList2.findNode(node.getId()).getChildren());
            if (children.isEmpty()) {
                i.remove();
                continue;
            }
            node.addChildren(children);
        }
        return intersection;
    }

    private void setTaskTargets(List taskNodes, List targets, String parent) {
        TaskNode node = null;
        TaskUrl url = null;
        Iterator i = taskNodes.iterator();
        while (i.hasNext()) {
            node = (TaskNode)i.next();
            if (node.isTask()) {
                url = node.getUrl();
                url.setTargets(targets);
                url.setParent(parent);
                continue;
            }
            this.setTaskTargets(node.getChildren(), targets, parent);
        }
    }

    static {
        LOCK = new Object();
    }
}

